//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.soapstation;

import com.actional.soapstation.db.Transport;

/** <!-- ========================================================================================================== -->
* Helper methods for creating, groups.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class TransportsTask extends SSTTask
{
	public static final String	DEFAULT_LISTENER	= "http";
	public static final String	DEFAULT_SENDER		= "http";

	//=============================================================================================================
	// Default configuration if not specified.
	//=============================================================================================================
	
	protected Transport 	itsDefaultListener;
	protected Transport 	itsDefaultSender;
	
	protected Transport 	itsFoundDefaultListener;
	protected Transport 	itsFoundDefaultSender;

	public void setDefaultListener(Transport val)
	{
		itsDefaultListener = val;
	}

	public Transport getDefaultListener()
	{
		return itsDefaultListener;
	}

	public void setDefaultSender(Transport val)
	{
		itsDefaultSender = val;
	}

	public Transport getDefaultSender()
	{
		return itsDefaultSender;
	}

	/** <!-- ================================================================================================== -->
	* Retrieve the default Listener. If non has been specified, query the server to try and find one.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public Transport defaultListener() throws Exception
	{
		if (itsDefaultListener != null)
			return itsDefaultListener;
		
		if (itsFoundDefaultListener != null)
			return itsFoundDefaultListener;
		
		itsFoundDefaultListener = (Transport)config().findFirst(Transport.class, DEFAULT_LISTENER);
		return itsFoundDefaultListener;
	}

	/** <!-- ================================================================================================== -->
	* Retrieve the default Listener. If non has been specified, query the server to try and find one.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public Transport defaultSender() throws Exception
	{
		if (itsDefaultSender != null)
			return itsDefaultSender;
			
		if (itsFoundDefaultSender != null)
			return itsFoundDefaultSender;
		
		itsFoundDefaultSender = (Transport)config().findFirst(Transport.class, DEFAULT_SENDER);
		return itsFoundDefaultSender;
	}
}
